/* -*-C-*-
 ##############################################################################
 #
 # File:        e1430/include/sicl_e.h
 # RCS:         "@(#)$Revision: 1.2 $ $Date: 94/03/17 09:00:30 $"
 # Description: header file for SICL Emulation code
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # This is the header file for Emulating the Standard Instrument 
 # Control Library (SICL) functions.  It is used when porting code
 # written for SICL to a platform which does not support SICL.
 # This file replaces the normal include file provided with SICL,  sicl.h
 #
 # Only a small subset of the sicl functions are emulated.
 #
 ##############################################################################
*/


#ifndef _SICL_E_INCLUDED
#define _SICL_E_INCLUDED


   /**********************************************
    * Definition of INST.   INST is returned
    * by iopen() and passed to other functions
    ********************************************/

typedef int INST;


   /**********************************************
    * iopen() and iclose() create and terminate
    * a SICL session.   Addr specifies the 
    * interface, like "vxi".
    ********************************************/

INST iopen(char *addr);
int iclose(INST id);


   /**********************************************
    * iwpeek(), iwpoke()  read and write 16-bit
    * words.  They are handled as macros.
    * On Intel platforms, these must do byte-swap.
    **********************************************/

#define  iwpoke(addr,val)  (*(volatile unsigned short *)(addr))=((unsigned short)(val))
#define  iwpeek(addr)      *((volatile unsigned short *)(addr))


   /**********************************************
    * imap() maps a memory space the user' 
    * process space.  In this case it returns 
    * a pointer to the beginning of VXI memory.
    **********************************************/

#define I_MAP_A16		0x0000
#define I_MAP_A24		0x0001
#define I_MAP_A32		0x0002
#define I_MAP_VXIDEV		0x0003
#define I_MAP_EXTEND		0x0004
#define I_MAP_INTFREG		0x0005
#define I_MAP_SHARED 		0x0006  

char * imap(INST id, int mapspace, unsigned int pagestart, unsigned int pagecnt, char *suggested);

#endif /*_SICL_E_INCLUDED */


